-- Macro Scripts File
-- Created:  Sep 06 2001
-- Author:   Alexander Esppeschit Bicalho


/*
Revision History
	13 sept 2001; Pierre-Felix Breton
	added snap mode toggle
	changed the cancellation prompt to be shown for 1 second
	
	19 sept 2001; Pierre-Felix Breton
	removed snap mode toggle

	24 mai 2003; Pierre-Felix Breton
	Added to 3ds MAX 6
	
	12 dec 2003, Pierre-Felix Breton, 
	added product switcher: this macro file can be shared with all Discreet products

*/

-- Macro Script to measure the distance between 2 points
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript two_point_dist
            category:~TWO_POINT_DIST_CATEGORY~ 
            internalCategory:"Tools" 
            tooltip:~TWO_POINT_DIST_TOOLTIP~ 
            buttontext:~TWO_POINT_DIST_BUTTONTEXT~ 
            iconName:"Extras/MeasureDistance"
(

	local pt1, pt2, str1, str2, str3, str4, str5, strDist, dist,  strDx, strDy, strDz

	local CurSnapModeActive, CurSnapModeType
	/* Start localization */
	

	fn RestoreSnaps = 
	(
			-- restores the snap mode that was setup before the command was invoked	
			snapMode.Active = CurSnapModeActive
			if snapMode.type == undefined do snapMode.type = #3D -- I have seen some old files where the mode was undefined, this is for security.
			snapMode.type = CurSnapModeType
	)
		
	str1 = ~STR1_CAPTION~
	str2 = ~STR2_CAPTION~ -- there are leading and a trailing spaces
	str3 = ~STR3_CAPTION~
	str4 = ~STR4_CAPTION~
	str5 = ~STR5_CANCELED~
	
	/* End localization */

	-- saves the snap mode that was used before the command was invoked
	--CurSnapModeActive = snapMode.Active
	--CurSnapModeType = snapMode.type

	-- activate the snap mode
	--snapMode.Active = True
	--if CurSnapModeActive == false do snapMode.type = #3d --if no snap was defined, assume that a default to per vertex would be good
		
	-- picks a first point
	pt1 = pickpoint snap:#3d
	
	if classof pt1 == point3 then
	(
		pt2 = pickpoint snap:#3d rubberband:pt1
		if classof pt2 == point3 then
		(
			dist = (distance pt1 pt2)
			strDist =  units.formatValue dist
	        strDx = units.formatValue ((((pt2.x-pt1.x) * 1000) as integer) / 1000.0)
			strDy = units.formatValue((((pt2.y-pt1.y) * 1000) as integer) / 1000.0)
			strDz = units.formatValue((((pt2.z-pt1.z) * 1000) as integer) / 1000.0)
			--RestoreSnaps()
			replacePrompt (str1 + strDist + str2 + strDx + str3 + strDy + str4 + strDz)	
			print (str1 + strDist)
		)
		else 
		(
			--RestoreSnaps() 	
			displayTempPrompt str5 1000 --the user cancelled
		)
	)
	else 
	(
		--RestoreSnaps() 	
		displayTempPrompt str5 1000 --the user cancelled
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCuU61wgYCu08ygutGbYNJoG8reUvtTgHzV
-- s3je7zr2V9pDZ4DIjMQVFsXbhaIHEPX8eqOGgFRh+9X827lLNEgAYdJiv9uASUel
-- f3PZEniTXX07oRalabLZnr7G9w5ZNpL2LnfsnfMp5bjbHHlHL8oCYYj70jO5kxoG
-- 7cZ/yl4HM+tY9T4yMPeQfKI9QG9DqR3QuHhE2cYu7ujdClIPzlVnPyIHqyjnHsZu
-- KfO/hnAPKkgISPyZTb4Jw67ajue/c3Cj9E4fvKs+iZjnt6zMTBpF3beGKBXELUOH
-- o21A7Fg0Z9oYjVk/aOJhSzdbnfP85/pB7ciE0YEqRRnAEOWKyIfe
-- -----END-SIGNATURE-----